//Downloaded from
//Visual C# Kicks - http://vckicks.110mb.com/
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;

namespace DragAndDropFile
{
    public partial class frmDragDrop : Form
    {
        public frmDragDrop()
        {
            InitializeComponent();
            //Important
            txtFileDrop.AllowDrop = true;
            lDirDrop.AllowDrop = true;
        }

        private void txtFileDrop_DragEnter(object sender, DragEventArgs e)
        {
            if (e.Data.GetDataPresent(DataFormats.FileDrop))
                e.Effect = DragDropEffects.Copy; //important to get the process to work
        }

        private void txtFileDrop_DragDrop(object sender, DragEventArgs e)
        {
            string[] fileNames = (string[])e.Data.GetData(DataFormats.FileDrop);
            txtFileDrop.Text = fileNames[0]; //Dragging only one file
        }

        private void lDirDrop_DragEnter(object sender, DragEventArgs e)
        {
            if (e.Data.GetDataPresent(DataFormats.FileDrop))
                e.Effect = DragDropEffects.Copy;
        }

        private void lDirDrop_DragDrop(object sender, DragEventArgs e)
        {
            string[] directoryName = (string[])e.Data.GetData(DataFormats.FileDrop);

            //Get all the folders inside that folder
            string[] dirs = Directory.GetDirectories(directoryName[0]);

            //Get all the files inside that folder
            string[] files = Directory.GetFiles(directoryName[0]);

            lDirDrop.Items.Clear();

            foreach (string dir in dirs)
            {
                lDirDrop.Items.Add(dir);
            }

            foreach (string file in files)
            {
                lDirDrop.Items.Add(file);
            }
        }
    }
}