//Download from
//Visual C# Kicks - http://www.vcskicks.com/

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using BitmapProcessing; //our assembly

namespace BitmapTester
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        #region Fast Bitmap Transform

        private Bitmap transformImage(Image image, Color target, Color replace, int tolerance)
        {
            return transformImage(new Bitmap(image), target, replace, tolerance);
        }

        //Replaces the target color with the selected color
        private Bitmap transformImage(Bitmap bmp, Color target, Color replace, int tolerance)
        {
            //Create a new blank image
            Bitmap newBmp = new Bitmap(bmp.Width, bmp.Height);

            //Edit/Read the images with our FastBitmap class
            FastBitmap original = new FastBitmap(bmp);
            FastBitmap output = new FastBitmap(newBmp);

            //Lock both images to make them editable/readable
            original.LockImage();
            output.LockImage();

            this.Text = "Processing Image..."; //alert user the program is working

            //Look through the original image
            for (int x = 0; x < bmp.Width; x++)
            {
                for (int y = 0; y < bmp.Height; y++)
                {
                    Application.DoEvents(); //Keep application from crashing

                    Color originalColor = original.GetPixel(x, y);
                    //Match the current bitmap color with the target bitmap
                    if (isMatch(originalColor, target, tolerance))
                    {
                        //Write the new color instead
                        output.SetPixel(x, y, replace);
                    }
                    else
                    {
                        //Write the original color
                        output.SetPixel(x, y, originalColor);
                    }
                }
            }

            //Unlock the images
            original.UnlockImage();
            output.UnlockImage();

            this.Text = "Fast Image Processing"; //original title

            //Return the final bitmap (not the FastBitmap object)
            return newBmp;
        }

        #endregion

        #region Regular GDI+ Transform

        private Bitmap transformImageRegular(Image image, Color target, Color replace, int tolerance)
        {
            return transformImage(new Bitmap(image), target, replace, tolerance);
        }

        //Replaces the target color with the selected color
        private Bitmap transformImageRegular(Bitmap bmp, Color target, Color replace, int tolerance)
        {
            //Create a new blank image
            Bitmap newBmp = new Bitmap(bmp.Width, bmp.Height);

            this.Text = "Processing Image..."; //alert user the program is working

            //Look through the original image
            for (int x = 0; x < bmp.Width; x++)
            {
                for (int y = 0; y < bmp.Height; y++)
                {
                    Application.DoEvents(); //Keep application from crashing

                    Color originalColor = bmp.GetPixel(x, y);
                    //Match the current bitmap color with the target bitmap
                    if (isMatch(originalColor, target, tolerance))
                    {
                        //Write the new color instead
                        newBmp.SetPixel(x, y, replace);
                    }
                    else
                    {
                        //Write the original color
                        newBmp.SetPixel(x, y, originalColor);
                    }
                }
            }

            this.Text = "Fast Image Processing"; //original title

            //Return the final bitmap (not the FastBitmap object)
            return newBmp;
        }

        #endregion

        private bool isMatch(Color color1, Color color2, int tolerance)
        {
            //The difference in values of RGB should be within the tolerance level
            return Math.Abs(color1.R - color2.R) <= tolerance &&
                   Math.Abs(color1.G - color2.G) <= tolerance &&
                   Math.Abs(color1.B - color2.B) <= tolerance;
        }

        private void pTarget_MouseDoubleClick(object sender, MouseEventArgs e)
        {
            if (colorDialog1.ShowDialog() == DialogResult.OK)
            {
                pTarget.BackColor = colorDialog1.Color;
            }
        }

        private void pNew_MouseDoubleClick(object sender, MouseEventArgs e)
        {
            if (colorDialog1.ShowDialog() == DialogResult.OK)
            {
                pNew.BackColor = colorDialog1.Color;
            }
        }

        private void btnTransform_Click(object sender, EventArgs e)
        {
            if (picOld.Image != null)
            {
                if (rRegular.Checked)
                    picNew.Image = (Image)transformImageRegular(picOld.Image, pTarget.BackColor, pNew.BackColor, 5);
                else if (rFast.Checked)
                    picNew.Image = (Image)transformImage(picOld.Image, pTarget.BackColor, pNew.BackColor, 5);
            }
        }

        private void btnLoad_Click(object sender, EventArgs e)
        {
            if (open1.ShowDialog() == DialogResult.OK)
            {
                picOld.Image = Image.FromFile(open1.FileName);
            }
        }

        private void btnSave_Click(object sender, EventArgs e)
        {
            if (picNew.Image != null && save1.ShowDialog() == DialogResult.OK)
            {
                picNew.Image.Save(save1.FileName, System.Drawing.Imaging.ImageFormat.Bmp);
            }
        }

        private void linkLabel1_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            System.Diagnostics.Process.Start("http://www.vcskicks.com/");
        }
    }
}