﻿//====================================================
//| Downloaded From                                  |
//| Visual C# Kicks - http://www.vcskicks.com/       |
//| License - http://www.vcskicks.com/license.php    |
//====================================================
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Text;

namespace VCSKicks
{
    public static class ConfigTransform
    {
        private const string TRANSFORM_PROJECT = @"<Project ToolsVersion=""4.0"" DefaultTargets=""Demo"" xmlns=""http://schemas.microsoft.com/developer/msbuild/2003"">
    <UsingTask TaskName=""TransformXml"" AssemblyFile=""$(MSBuildExtensionsPath)\Microsoft\VisualStudio\v10.0\Web\Microsoft.Web.Publishing.Tasks.dll""/>
    <Target Name=""Transform"">
        <TransformXml Source=""{source}"" Transform=""{transform}"" Destination=""{destination}""/>
    </Target>
</Project>";

        public static string ApplyTransformation(string configFile, string transformFile)
        {
            return ApplyTransformation(@"C:\Windows\Microsoft.NET\Framework64\v4.0.30319\msbuild.exe", configFile, transformFile);
        }

        public static string ApplyTransformation(string msBuildPath, string configFile, string transformFile)
        {
            using (TempFile proj = new TempFile())
            using (TempFile output = new TempFile())
            {
                //Create transformation project
                string project = TRANSFORM_PROJECT.Replace("{source}", configFile)
                                                  .Replace("{transform}", transformFile)
                                                  .Replace("{destination}", output.Filename);
                File.WriteAllText(proj.Filename, project);

                //Run the project
                ProcessStartInfo cmd = new ProcessStartInfo(msBuildPath, proj.Filename + " /t:Transform");
                cmd.CreateNoWindow = true;
                cmd.UseShellExecute = false;
                Process.Start(cmd)
                       .WaitForExit();

                //Return output
                return File.ReadAllText(output.Filename);
            }
        }
    }
}
