//===============================================
//| Downloaded from                             |
//| Visual C# Kicks - http://www.vcskicks.com/  |
//===============================================

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Threading; //Needed

namespace CrossThreadCalls
{
    public partial class Form1 : Form
    {
        //Fields
        private bool started;
        private Thread blinkingThread;
        private DateTime lastSwitch;

        public Form1()
        {
            InitializeComponent();
        }

        //Starts or stops the blinker thread accordinly
        private void btnAct_Click(object sender, EventArgs e)
        {
            if (started)
            {
                started = false;
                btnAct.Text = "Start";

                //End the blinking thread
                if (blinkingThread != null) //clean up previous
                {
                    blinkingThread.Abort();
                    blinkingThread = null;
                }
            }
            else
            {
                started = true;
                btnAct.Text = "Stop";

                //Begin the blinking thread
                if (blinkingThread != null) //clean up previous
                    blinkingThread.Abort();

                ParameterizedThreadStart starter = new ParameterizedThreadStart(BlinkHelper);
                blinkingThread = new Thread(starter);
                object secondsInterval = 1; //1 second interval
                blinkingThread.Start(secondsInterval);
            }
        }

        //Keeps the blinking loop running
        private void BlinkHelper(object secondsInterval)
        {
            //Keep looking the blinker
            do
            {
                Blink((int)secondsInterval);
                Application.DoEvents();
                Thread.Sleep(1); //Free up CPU
            } while (true);
        }

        //Performs the actual "blink"
        private delegate void BlinkDelegate(int secondsInterval); //Used to call Blink function, parameters must be the same
        private void Blink(int secondsInterval)
        {
            if (this.InvokeRequired)
            {
                //Setup the cross-thread call
                BlinkDelegate del = new BlinkDelegate(Blink); //delegate
                object[] parameters = { secondsInterval }; //parameters
                this.Invoke(del, parameters); //call
            }
            else
            {
                //Already cross-threading, do the actions
                if (lastSwitch == null)
                {
                    //start with red
                    pBlinker.BackColor = Color.Red;
                    lastSwitch = DateTime.Now;
                }
                else
                {
                    if (DateTime.Now.Subtract(lastSwitch).Seconds >= secondsInterval) //enough time has passed to make the switch
                    {
                        //set the opposite color
                        pBlinker.BackColor = pBlinker.BackColor == Color.Red ? Color.Green : Color.Red;
                        lastSwitch = DateTime.Now;
                        this.Refresh();
                    }
                }
            }
        }

        //Clean up threading before closing
        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (blinkingThread != null)
                blinkingThread.Abort(); //stop the thread before closing
        }

        private void linkLabel1_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            System.Diagnostics.Process.Start("http://www.vcskicks.com/");
        }
    }
}