//====================================================
//| Downloaded From                                  |
//| Visual C# Kicks - http://www.vcskicks.com/       |
//| License - http://www.vcskicks.com/license.html   |
//====================================================
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;
using System.Runtime.InteropServices;

namespace DiskDrive
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();

            //Populate the list of disk drives
            getDrives(ref cDrives);
        }

        [DllImport("winmm.dll", EntryPoint = "mciSendString")]
        public static extern int mciSendStringA(string lpstrCommand, string lpstrReturnString, int uReturnLength, int hwndCallback);

        private void getDrives(ref ComboBox cList)
        {
            //Clear list
            cList.Items.Clear();

            //Add only CD drives
            foreach (DriveInfo drive in DriveInfo.GetDrives())
            {
                if (drive.DriveType == DriveType.CDRom)
                    cList.Items.Add(drive.RootDirectory);
            }
        }

        private void openDrive(string driveRoot)
        {
            string driveLetter = driveRoot[0].ToString();
            string returnString = string.Empty;

            //Set a name for the specified disk drive
            mciSendStringA("open " + driveLetter + ": type CDaudio alias drive" + driveLetter, returnString, 0, 0);

            //open the disk tray
            mciSendStringA("set drive" + driveLetter + " door open", returnString, 0, 0);
        }

        private void closeDrive(string driveRoot)
        {
            string driveLetter = driveRoot[0].ToString();
            string returnString = string.Empty;

            //Set a name for the specified disk drive
            mciSendStringA("open " + driveLetter + ": type CDaudio alias drive" + driveLetter, returnString, 0, 0);

            //close the disk tray
            mciSendStringA("set drive" + driveLetter + " door closed", returnString, 0, 0);
        }

        private void btnOpen_Click(object sender, EventArgs e)
        {
            if (cDrives.Text != string.Empty)
                openDrive(cDrives.Text);
        }

        private void btnClose_Click(object sender, EventArgs e)
        {
            if (cDrives.Text != string.Empty)
                closeDrive(cDrives.Text);
        }

        private void linkLabel1_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            System.Diagnostics.Process.Start("http://www.vcskicks.com/");
        }
    }
}