// ================================================
// | Downloaded From                              |
// | Visual C# Kicks - http://www.vcskicks.com/   |
// ================================================
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace DistanceFormula
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();

            //Attach events
            txtX1.KeyPress +=new KeyPressEventHandler(txtX1_KeyPress);
            txtY1.KeyPress += new KeyPressEventHandler(txtX1_KeyPress);
            txtX2.KeyPress += new KeyPressEventHandler(txtX1_KeyPress);
            txtY2.KeyPress += new KeyPressEventHandler(txtX1_KeyPress);
        }

        //Accepts only number input => http://www.vcskicks.com/numbers_only_textbox.html
        private void txtX1_KeyPress(object sender, KeyPressEventArgs e)
        {
            e.Handled = !System.Text.RegularExpressions.Regex.IsMatch(e.KeyChar.ToString(), "\\d+");
        }

        private static double GetDistance(PointF point1, PointF point2)
        {
            //pythagoras theorem c^2 = a^2 + b^2
            //thus c = square root(a^2 + b^2)
            double a = (double)(point2.X - point1.X);
            double b = (double)(point2.Y - point1.Y);

            return Math.Sqrt(a * a + b * b);
        }

        private void btnDistance_Click(object sender, EventArgs e)
        {
            PointF point1 = new PointF(float.Parse(txtX1.Text), float.Parse(txtY1.Text));
            PointF point2 = new PointF(float.Parse(txtX2.Text), float.Parse(txtY2.Text));

            txtDistance.Text = GetDistance(point1, point2).ToString();
        }

        private void linkLabel1_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            System.Diagnostics.Process.Start("http://www.vcskicks.com/");
        }
    }
}