//====================================================
//| Downloaded From                                  |
//| Visual C# Kicks - http://www.vcskicks.com/       |
//| License - http://www.vcskicks.com/license.html   |
//====================================================
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Net;
using System.Net.Mail; //<--- Instead of System.Web.Mail
using System.Collections;

namespace EmailSMTP
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void btnSend_Click(object sender, EventArgs e)
        {
            SendSMTP();
        }

        private void txtPort_KeyPress(object sender, KeyPressEventArgs e)
        {
            //Accept only number keystrokes
            e.Handled = !System.Text.RegularExpressions.Regex.IsMatch(e.KeyChar.ToString(), "\\d+");
        }

        private void txtUsername_Leave(object sender, EventArgs e)
        {
            //Enfore that the username include the gmail.com part
            if (txtUsername.Text != String.Empty &&
                txtUsername.Text.IndexOf("@gmail.com") == -1)
                txtUsername.Text += "@gmail.com";
        }

        public void SendSMTP()
        {
            //Set up SMTP client
            SmtpClient client = new SmtpClient();
            client.Host = txtServer.Text;
            client.Port = int.Parse(txtPort.Text);
            client.DeliveryMethod = SmtpDeliveryMethod.Network;
            client.Credentials = new NetworkCredential(txtUsername.Text, txtPassword.Text);
            client.EnableSsl = true;

            //Set up the email message
            MailMessage message = new MailMessage();
            message.To.Add(txtTo.Text);
            message.From = new MailAddress(txtUsername.Text);
            message.Subject = txtSubject.Text;
            message.IsBodyHtml = true; //HTML email
            message.Body = txtBody.Text;
            
            //Attempt to send the email
            try
            {
                client.Send(message);
                MessageBox.Show("Message Successfully Sent");
            }
            catch (Exception ex)
            {
                MessageBox.Show("There was an error while sending the message:\n\n" + ex.ToString());
            }
        }

        private void linkLabel1_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            System.Diagnostics.Process.Start("http://www.vcskicks.com/");
        }
    }
}