﻿//====================================================
//| Downloaded From                                  |
//| Visual C# Kicks - http://www.vcskicks.com/       |
//| License - http://www.vcskicks.com/license.php    |
//====================================================
using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Text;

namespace EnumToString
{
    [AttributeUsage(AttributeTargets.Field, AllowMultiple = true)]
    class ReadableStringAttribute : Attribute
    {
        private string str;
        public string ReadableString
        {
            get { return str; }
        }

        public ReadableStringAttribute(string str)
        {
            this.str = str;
        }
    }

    static class EnumHelper
    {
        public static string ToReadableString(this Enum en)
        {
            string str = en.ToString(); //by default fall back to regular string

            //Find the first readable string attribute
            Type enumType = en.GetType();
            FieldInfo currentValue = enumType.GetField(en.ToString());

            object[] attributes = currentValue.GetCustomAttributes(typeof(ReadableStringAttribute), inherit: false) ?? new object[0];
            if (attributes.Length > 0)
                str = ((ReadableStringAttribute)attributes[0]).ReadableString;

            return str;
        }

        public static T ParseReadableString<T>(string str, bool ignoreCase = false) where T : struct //Enum
        {
            if (!typeof(T).IsEnum)
                throw new ArgumentException("T must be an enum", "T");

            FieldInfo[] values = typeof(T).GetFields() ?? new FieldInfo[0];

            //Find a value (field) of enum T that has a ReadableString attribute matching the input string
            foreach (FieldInfo value in values)
            {
                object[] attributes = value.GetCustomAttributes(typeof(ReadableStringAttribute), inherit: false) ?? new object[0];
                foreach (object attr in attributes)
                {
                    string readableStr = ((ReadableStringAttribute)attr).ReadableString;
                    if (string.Compare(str, readableStr, ignoreCase) == 0)
                        return (T)value.GetValue(null);
                }
            }

            //No match found, try to find one based on the name instead
            T parsedValue = default(T);
            bool matchFound = Enum.TryParse<T>(str, ignoreCase, out parsedValue);
            if (matchFound)
                return parsedValue;
            else
                throw new ArgumentException("Unknown value " + str, "str");
        }
    }
}
