//===============================================
//| Downloaded from                             |
//| Visual C# Kicks - http://www.vcskicks.com/  |
//===============================================
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace EuclideanAlgorithm
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();

            //Attach events to textbox to only allow numbers to be entered
            txtNum1.KeyPress += new KeyPressEventHandler(txtNum_KeyPress);
            txtNum2.KeyPress += new KeyPressEventHandler(txtNum_KeyPress);
        }

        void txtNum_KeyPress(object sender, KeyPressEventArgs e)
        {
            //Block keys that are not numbers
            e.Handled = !System.Text.RegularExpressions.Regex.IsMatch(e.KeyChar.ToString(), "\\d+");
        }

        private void btnGCD_Click(object sender, EventArgs e)
        {
            if (txtNum1.Text == string.Empty)
                txtNum1.Text = "0";

            if (txtNum2.Text == string.Empty)
                txtNum2.Text = "0";

            txtAnswer.Text = GCD(int.Parse(txtNum1.Text), int.Parse(txtNum2.Text)).ToString();
        }

        /// <summary>
        /// Returns the Greatest Common Denominator of two integers using the Euclidean Algorithm recursively.
        /// </summary>
        public int GCDRecursive(int a, int b)
        {
            //Base cases
            if (a == 0)
                return b;

            if (b == 0)
                return a;

            if (a > b)
                return GCDRecursive(a % b, b);
            else
                return GCDRecursive(a, b % a);
        }

        /// <summary>
        /// Returns the Greatest Common Denominator of two integers using the Euclidean Algorithm non-recursively.
        /// </summary>
        public int GCD(int a, int b)
        {
            while (a != 0 && b != 0)
            {
                if (a > b)
                    a %= b;
                else
                    b %= a;
            }

            if (a == 0)
                return b;
            else
                return a;
        }

        private void linkLabel1_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            System.Diagnostics.Process.Start("http://www.vcskicks.com/");
        }
    }
}