// ================================================
// | Downloaded From                              |
// | Visual C# Kicks - http://www.vcskicks.com/   |
// ================================================
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
//Needed
using System.Net;
using System.IO;

namespace ExtractLinks
{
    public partial class MainForm : Form
    {
        public MainForm()
        {
            InitializeComponent();

            //Attached CheckedChanged event
            rURL.CheckedChanged += new EventHandler(CheckedChanged);
            rCode.CheckedChanged += new EventHandler(CheckedChanged);
        }

        //Enables/disables the textboxes accordingly
        private void CheckedChanged(object sender, EventArgs e)
        {
            txtURL.ReadOnly = !rURL.Checked;
            txtCode.ReadOnly = !rCode.Checked;
        }

        private void txtURL_Leave(object sender, EventArgs e)
        {
            //Make sure http:// is at the beginning of the link
            if (!txtURL.Text.StartsWith("http://"))
                txtURL.Text = "http://" + txtURL.Text;
        }

        private void btnExtract_Click(object sender, EventArgs e)
        {
            if (rCode.Checked)
            {
                //Already have raw code
                frmListDialog diag = new frmListDialog(ExtractLinks(txtCode.Text));
                diag.ShowDialog();
            }
            else //if (rURL.Checked)
            {
                //Get raw code from URL
                string rawCode = DownloadData(txtURL.Text);

                //Extract links
                frmListDialog diag = new frmListDialog(ExtractLinks(rawCode));
                diag.ShowDialog();
            }
        }

        private List<string> ExtractLinks(string rawCode)
        {
            List<string> links = new List<string>();

            string startSquence = "<a href=\"";
            string endSequence = "\"";

            rawCode = rawCode.ToLower();

            while (rawCode.IndexOf("<a href") != -1)
            {
                int start = rawCode.IndexOf(startSquence) + startSquence.Length;
                int end = rawCode.IndexOf(endSequence, start);

                //Extract the link, and add it to the list
                if (end > start)
                {
                    string link = rawCode.Substring(start, end - start);

                    if (link != string.Empty)
                    {
                        if (!link.StartsWith("http://"))
                        {
                            //It's a relative link, add a ..
                            link = "../" + link;
                        }

                        links.Add(link);
                    }
                }

                //Trim the raw data
                rawCode = rawCode.Substring(end + endSequence.Length);
            }

            return links;
        }

        private string DownloadData(string url)
        {
            byte[] downloadedData = new byte[0];
            try
            {
                //Get a data stream from the url
                WebRequest req = WebRequest.Create(url);
                WebResponse response = req.GetResponse();
                Stream stream = response.GetResponseStream();

                //Download in chuncks
                byte[] buffer = new byte[1024];

                //Get Total Size
                int dataLength = (int)response.ContentLength;

                //Download to memory
                MemoryStream memStream = new MemoryStream();
                while (true)
                {
                    //Try to read the data
                    int bytesRead = stream.Read(buffer, 0, buffer.Length);

                    //Avoid application freezing
                    Application.DoEvents();

                    if (bytesRead == 0)
                    {
                        //Finished downloading                       
                        break;
                    }
                    else
                    {
                        //Write the downloaded data
                        memStream.Write(buffer, 0, bytesRead);
                    }
                }

                //Convert the downloaded stream to a byte array
                downloadedData = memStream.ToArray();

                //Clean up
                stream.Close();
                memStream.Close();
            }
            catch (Exception)
            {
                //May not be connected to the internet
                //Or the URL might not exist
                MessageBox.Show("There was an error accessing the URL.");
            }

            //Convert the data into string
            return ASCIIEncoding.ASCII.GetString(downloadedData);
        }

        private void linkLabel1_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            System.Diagnostics.Process.Start("http://www.vcskicks.com/");
        }
    }
}