//Downloaded from
//Visual C# Kicks - http://www.vcskicks.com/

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Threading; //Needed

namespace FadingForm
{
    public partial class Form1 : Form
    {
        private double idleOpacity = 0.7; //how opaque it is when the mouse is not on it
        private double fadeRate = 0.001; //how fast the form fades in/out

        Thread fadeIn;
        Thread fadeOut;

        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            this.DoubleBuffered = true;
            this.TransparencyKey = Color.Lime; //Prevent flicker from opacity change by forcing
            //The form to be layered now

            this.Opacity = idleOpacity;

            //Prepare the fade in/out threads that will be called later
            ThreadStart fadeInStart = new ThreadStart(FadeIn);
            fadeIn = new Thread(fadeInStart);

            ThreadStart fadeOutStart = new ThreadStart(FadeOut);
            fadeOut = new Thread(fadeOutStart);
        }

        private void Form1_Paint(object sender, PaintEventArgs e)
        {
            //Draw a solid backgroud with a thin border
            Graphics draw = e.Graphics;
            draw.SmoothingMode = System.Drawing.Drawing2D.SmoothingMode.AntiAlias;

            Rectangle area = this.ClientRectangle;
            area.Width -= 1;
            area.Height -= 1;

            Pen outline = new Pen(Color.Gold, 1);

            draw.FillRectangle(Brushes.LightYellow, this.ClientRectangle); //Background
            draw.DrawRectangle(outline, area); //Border

            outline.Dispose();
        }

        //Changing opacity will be a cross-thread operation, delegates are in order
        private delegate void ChangeOpacityDelegate(double value);
        private void ChangeOpacity(double value)
        {
            if (this.InvokeRequired)
            {
                ChangeOpacityDelegate del = new ChangeOpacityDelegate(ChangeOpacity);
                object[] parameters = { value };

                this.Invoke(del, value);
            }
            else
            {
                this.Opacity = value;
            }
        }

        private void FadeIn()
        {
            for (double i = this.Opacity; i <= 1; i += fadeRate)
            {
                ChangeOpacity(i);
            }

            if (this.Opacity != 1.00)
                ChangeOpacity(1.00);
        }

        private void FadeOut()
        {
            for (double i = this.Opacity; i >= idleOpacity; i -= fadeRate)
            {
                ChangeOpacity(i);
            }

            if (this.Opacity != idleOpacity)
                ChangeOpacity(idleOpacity);
        }

        #region --------Drag Behavior------------

        Point lastPoint;
        private void Form1_MouseDown(object sender, MouseEventArgs e)
        {
            lastPoint = new Point(e.X, e.Y);
        }

        private void Form1_MouseMove(object sender, MouseEventArgs e)
        {
            if (e.Button == MouseButtons.Left || e.Button == MouseButtons.Right)
            {
                this.Left += e.X - lastPoint.X;
                this.Top += e.Y - lastPoint.Y;
            }
        }

        #endregion        

        #region ----------Fade Behavior-------------

        private void Form1_MouseEnter(object sender, EventArgs e)
        {
            //Cancel running fading threads to avoid overflowing the stack
            if (fadeIn.ThreadState == ThreadState.Running)
                fadeIn.Abort();

            if (fadeOut.ThreadState == ThreadState.Running)
                fadeOut.Abort();

            //Begin fading in
            ThreadStart fadeInStart = new ThreadStart(FadeIn);
            fadeIn = new Thread(fadeInStart);

            fadeIn.Start();
        }

        private void Form1_MouseLeave(object sender, EventArgs e)
        {
            //If the mouse goes over a control in the form, the MouseLeave event (this one)
            //is called. We do not want to fade out if the mouse is still pointing at something
            //inside the form. This is a quick dirty fix, just check if the mouse is within
            //the form's bounds
            if (this.Bounds.Contains(Cursor.Position)) return;

            //Cancel running fading threads to avoid overflowing the stack
            if (fadeIn.ThreadState == ThreadState.Running)
                fadeIn.Abort();

            if (fadeOut.ThreadState == ThreadState.Running)
                fadeOut.Abort();

            //Begin fading out
            ThreadStart fadeOutStart = new ThreadStart(FadeOut);
            fadeOut = new Thread(fadeOutStart);

            fadeOut.Start();
        }

        #endregion

        //Handling control behavior
        private void linkLabel1_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            System.Diagnostics.Process.Start("http://www.vcskicks.com/");
        }
    }
}