﻿using System;
using System.Collections.Generic;
using System.Text;

namespace VCSKicks
{
    static class Sorting
    {
        //Simpler version to understand
        public static int[] FiveSortIntegers(IList<int> list)
        {
            if (list.Count != 5)
                throw new Exception("FiveSort only works for lists of five items");

            //a = list[0]
            //b = list[1]
            //c = list[2]
            //d = list[3]
            //e = list[4]

            //a > b?
            if (list[0] > list[1])
            {
                //Swap a and b
                int temp = list[1];
                list[1] = list[0];
                list[0] = temp;
            }

            //c > d?
            if (list[2] > list[3])
            {
                //Swap c and d
                int temp = list[3];
                list[3] = list[2];
                list[2] = temp;
            }

            //b > d?
            if (list[1] > list[3])
            {
                //Swap b and d
                int temp = list[3];
                list[3] = list[1];
                list[1] = temp;

                //Swap a and c
                temp = list[2];
                list[2] = list[0];
                list[0] = temp;
            }

            int a = list[0];
            int b = list[1];
            int c = list[2];
            int d = list[3];
            int e = list[4];

            int[] sortedArray = null;

            //Find position of e in a,b,d
            if (e >= b)
            {
                if (e < d)
                {
                    //a,b,e,d

                    //Find position of c
                    //c is less than d for sure
                    if (c >= b)
                    {
                        if (c < e)
                        {
                            //a,b,c,e,d
                            sortedArray = new int[] { a, b, c, e, d };
                        }
                        else
                        {
                            //a,b,e,c,d
                            sortedArray = new int[] { a, b, e, c, d };
                        }
                    }
                    else
                    {
                        if (c < a)
                        {
                            //c,a,b,e,d
                            sortedArray = new int[] { c, a, b, e, d };
                        }
                        else
                        {
                            //a,c,b,e,d
                            sortedArray = new int[] { a, c, b, e, d };
                        }
                    }
                }
                else
                {
                    //a,b,d,e

                    //Find position of c
                    //c is less than d for sure
                    if (c >= b)
                    {
                        //a,b,c,d,e
                        sortedArray = new int[] { a, b, c, d, e };
                    }
                    else
                    {
                        if (c < a)
                        {
                            //c,a,b,d,e
                            sortedArray = new int[] { c, a, b, d, e };
                        }
                        else
                        {
                            //a,c,b,d,e
                            sortedArray = new int[] { a, c, b, d, e };
                        }
                    }
                }
            }
            else //e < b
            {
                if (e < a)
                {
                    //e,a,b,d

                    //Find position of c
                    //c is less than d for sure
                    if (c >= a)
                    {
                        if (c < b)
                        {
                            //e,a,c,b,d
                            sortedArray = new int[] { e, a, c, b, d };
                        }
                        else
                        {
                            //e,a,b,c,d
                            sortedArray = new int[] { e, a, b, c, d };
                        }
                    }
                    else
                    {
                        if (c < e)
                        {
                            //c,e,a,b,d
                            sortedArray = new int[] { c, e, a, b, d };
                        }
                        else
                        {
                            //e,c,a,b,d
                            sortedArray = new int[] { e, c, a, b, d };
                        }
                    }
                }
                else
                {
                    //a,e,b,d

                    //Find position of c
                    //c is less than d for sure
                    if (c >= e)
                    {
                        if (c < b)
                        {
                            //a,e,c,b,d
                            sortedArray = new int[] { a, e, c, b, d };
                        }
                        else
                        {
                            //a,e,b,c,d
                            sortedArray = new int[] { a, e, b, c, d };
                        }
                    }
                    else
                    {
                        if (c < a)
                        {
                            //c,a,e,b,d
                            sortedArray = new int[] { c, a, e, b, d };
                        }
                        else
                        {
                            //a,c,e,b,d
                            sortedArray = new int[] { a, c, e, b, d };
                        }
                    }
                }
            }

            //return the sorted list
            return sortedArray;
        }

        //This version uses generics to sort any list of comparable objects
        public static IList<T> FiveSort<T>(IList<T> list) where T : IComparable
        {
            if (list.Count != 5)
                throw new Exception("FiveSort only works for lists of five items");

            //a = list[0]
            //b = list[1]
            //c = list[2]
            //d = list[3]
            //e = list[4]

            //a > b?
            if (list[0].CompareTo(list[1]) > 0)
            {
                //Swap a and b
                T temp = list[1];
                list[1] = list[0];
                list[0] = temp;
            }

            //c > d?
            if (list[2].CompareTo(list[3]) > 0)
            {
                //Swap c and d
                T temp = list[3];
                list[3] = list[2];
                list[2] = temp;
            }

            //b > d?
            if (list[1].CompareTo(list[3]) > 0)
            {
                //Swap b and d
                T temp = list[3];
                list[3] = list[1];
                list[1] = temp;

                //Swap a and c
                temp = list[2];
                list[2] = list[0];
                list[0] = temp;
            }

            T a = list[0];
            T b = list[1];
            T c = list[2];
            T d = list[3];
            T e = list[4];

            T[] sortedArray = null;

            //Find position of e in a,b,d
            if (e.CompareTo(b) >= 0)
            {
                if (e.CompareTo(d) < 0)
                {
                    //a,b,e,d

                    //Find position of c
                    //c is less than d for sure
                    if (c.CompareTo(b) >= 0)
                    {
                        if (c.CompareTo(e) < 0)
                        {
                            //a,b,c,e,d
                            sortedArray = new T[] { a, b, c, e, d };
                        }
                        else
                        {
                            //a,b,e,c,d
                            sortedArray = new T[] { a, b, e, c, d };
                        }
                    }
                    else
                    {
                        if (c.CompareTo(a) < 0)
                        {
                            //c,a,b,e,d
                            sortedArray = new T[] { c, a, b, e, d };
                        }
                        else
                        {
                            //a,c,b,e,d
                            sortedArray = new T[] { a, c, b, e, d };
                        }
                    }
                }
                else
                {
                    //a,b,d,e

                    //Find position of c
                    //c is less than d for sure
                    if (c.CompareTo(b) >= 0)
                    {
                        //a,b,c,d,e
                        sortedArray = new T[] { a, b, c, d, e };
                    }
                    else
                    {
                        if (c.CompareTo(a) < 0)
                        {
                            //c,a,b,d,e
                            sortedArray = new T[] { c, a, b, d, e };
                        }
                        else
                        {
                            //a,c,b,d,e
                            sortedArray = new T[] { a, c, b, d, e };
                        }
                    }
                }
            }
            else //e < b
            {
                if (e.CompareTo(a) < 0)
                {
                    //e,a,b,d

                    //Find position of c
                    //c is less than d for sure
                    if (c.CompareTo(a) >= 0)
                    {
                        if (c.CompareTo(b) < 0)
                        {
                            //e,a,c,b,d
                            sortedArray = new T[] { e, a, c, b, d };
                        }
                        else
                        {
                            //e,a,b,c,d
                            sortedArray = new T[] { e, a, b, c, d };
                        }
                    }
                    else
                    {
                        if (c.CompareTo(e) < 0)
                        {
                            //c,e,a,b,d
                            sortedArray = new T[] { c, e, a, b, d };
                        }
                        else
                        {
                            //e,c,a,b,d
                            sortedArray = new T[] { e, c, a, b, d };
                        }
                    }
                }
                else
                {
                    //a,e,b,d

                    //Find position of c
                    //c is less than d for sure
                    if (c.CompareTo(e) >= 0)
                    {
                        if (c.CompareTo(b) < 0)
                        {
                            //a,e,c,b,d
                            sortedArray = new T[] { a, e, c, b, d };
                        }
                        else
                        {
                            //a,e,b,c,d
                            sortedArray = new T[] { a, e, b, c, d };
                        }
                    }
                    else
                    {
                        if (c.CompareTo(a) < 0)
                        {
                            //c,a,e,b,d
                            sortedArray = new T[] { c, a, e, b, d };
                        }
                        else
                        {
                            //a,c,e,b,d
                            sortedArray = new T[] { a, c, e, b, d };
                        }
                    }
                }
            }

            //return the sorted list
            return sortedArray;
        }
    }
}
