//====================================================
//| Downloaded From                                  |
//| Visual C# Kicks - http://www.vcskicks.com/       |
//| License - http://www.vcskicks.com/license.html   |
//====================================================
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Text;
using System.Windows.Forms;

namespace FlipImage
{
    public partial class Form1 : Form
    {
        private Image loadedImage;

        public Form1()
        {
            InitializeComponent();
        }

        private void btnOpen_Click(object sender, EventArgs e)
        {
            if (openFileDialog1.ShowDialog() == DialogResult.OK)
            {
                try
                {
                    Image openedImage = Image.FromFile(openFileDialog1.FileName);

                    if (loadedImage != null)
                        loadedImage.Dispose(); //clean up

                    loadedImage = openedImage;
                    picImage.Image = loadedImage;
                }
                catch (Exception)
                {
                    MessageBox.Show("Invalid Image");
                }
            }
        }

        private void btnFlipHorizontally_Click(object sender, EventArgs e)
        {
            if (loadedImage != null)
            {
                Image flippedImage = FlipImage(loadedImage, true, false);

                loadedImage.Dispose();
                loadedImage = flippedImage;

                picImage.Image = loadedImage;
            }
        }

        private void btnFlipVertically_Click(object sender, EventArgs e)
        {
            if (loadedImage != null)
            {
                Image flippedImage = FlipImage(loadedImage, false, true);

                loadedImage.Dispose();
                loadedImage = flippedImage;

                picImage.Image = loadedImage;
            }
        }

        private void btnFlipBoth_Click(object sender, EventArgs e)
        {
            if (loadedImage != null)
            {
                Image flippedImage = FlipImage(loadedImage, true, true);

                loadedImage.Dispose();
                loadedImage = flippedImage;

                picImage.Image = loadedImage;
            }
        }

        public static Image FlipImage(Image image, bool flipHorizontally, bool flipVertically)
        {
            Bitmap flippedImage = new Bitmap(image.Width, image.Height);

            using (Graphics g = Graphics.FromImage(flippedImage))
            {
                //Matrix transformation
                Matrix m = null;
                if (flipVertically && flipHorizontally)
                {
                    m = new Matrix(-1, 0, 0, -1, 0, 0);
                    m.Translate(flippedImage.Width, flippedImage.Height, MatrixOrder.Append);
                }
                else if (flipVertically)
                {
                    m = new Matrix(1, 0, 0, -1, 0, 0);
                    m.Translate(0, flippedImage.Height, MatrixOrder.Append);
                }
                else if (flipHorizontally)
                {
                    m = new Matrix(-1, 0, 0, 1, 0, 0);
                    m.Translate(flippedImage.Width, 0, MatrixOrder.Append);
                }

                //Draw
                g.Transform = m;
                g.DrawImage(image, 0, 0);

                //clean up
                m.Dispose();
            }

            return (Image)flippedImage;
        }

        private void linkLabel1_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            System.Diagnostics.Process.Start("http://www.vcskicks.com/");
        }
    }
}