//====================================================
//| Downloaded From                                  |
//| Visual C# Kicks - http://www.vcskicks.com/       |
//| License - http://www.vcskicks.com/license.html   |
//====================================================
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;

namespace WindowsApplication1
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private string GenerateGetSet(string input, bool get, bool set)
        {
            StringReader reader = new StringReader(input);
            StringBuilder build = new StringBuilder();

            while (reader.Peek() != -1)
            {
                string line = reader.ReadLine();

                //Remove any initializing values
                int equalIndex = line.IndexOf('=');
                if (equalIndex != -1)
                    line = line.Substring(0, equalIndex);

                //Remove extra space at the start and end of the line
                line = line.TrimStart(' ');
                line = line.TrimEnd(' ');

                //Skip empty lines
                if (line == string.Empty)
                    continue;

                string[] parts = line.Split(' ');

                string type = string.Empty;
                string name = string.Empty;

                if (parts.Length == 2)
                {
                    //[type] [name]
                    type = parts[0];
                    name = parts[1];
                }
                else if (parts.Length == 3)
                {
                    //[accessor] [type] [name]
                    type = parts[1];
                    name = parts[2];
                }
                else
                    continue; //unrecognized string

                //Remove the semicolon at the end
                name = name.TrimEnd(';');

                string header = "public " + type + " " + Capitalize(name.TrimStart('_'));
                string getter = "    get { return this." + name + "; }";
                string setter = "    set { this." + name + " = value; }";

                //Add the strings to the final string
                build.AppendLine(header);
                build.AppendLine("{");
                if (get)
                    build.AppendLine(getter);
                if (set)
                    build.AppendLine(setter);
                build.AppendLine("}");
                build.AppendLine(""); //emtpy line
            }

            return build.ToString();
        }

        private string Capitalize(string input)
        {
            //Verify input
            if (string.IsNullOrEmpty(input)) return string.Empty;
            if (input.Length == 1) return input.ToUpper();

            if (char.IsUpper(input[0]))
                return input; //already capitalized
            else
            {
                char[] outputChars = input.ToCharArray();
                outputChars[0] = char.ToUpper(outputChars[0]);

                return new string(outputChars);
            }
        }

        private void btnGenerate_Click(object sender, EventArgs e)
        {
            txtGenerated.Text = GenerateGetSet(txtOriginal.Text, cGet.Checked, cSet.Checked);
        }

        private void btnClear_Click(object sender, EventArgs e)
        {
            txtOriginal.Text = string.Empty;
        }

        private void btnClear2_Click(object sender, EventArgs e)
        {
            txtGenerated.Text = string.Empty;
        }

        private void btnClipboard_Click(object sender, EventArgs e)
        {
            if (txtGenerated.Text != string.Empty)
            {
                Clipboard.SetText(txtGenerated.Text);
                MessageBox.Show("Text Copied to Clipboard");
            }
        }

        private void linkLabel1_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            System.Diagnostics.Process.Start("http://www.vcskicks.com/");
        }
    }
}