//---------------------------------------------
//Downloaded From
//Visual C# Kicks - http://www.vcskicks.com/
//---------------------------------------------
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
//Needed namespaces
using System.Runtime.InteropServices;
using System.IO;

namespace IconExtractor
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void btnBrowse_Click(object sender, EventArgs e)
        {
            if (openFileDialog1.ShowDialog() == DialogResult.OK)
                txtPath.Text = openFileDialog1.FileName;
        }

        private void btnExtract_Click(object sender, EventArgs e)
        {
            if (txtPath.Text != string.Empty && File.Exists(txtPath.Text))
            {
                //Extract both the large and small version of the icon
                Icon smallIcon = IconExtractor.ExtractIconSmall(txtPath.Text);
                Icon largeIcon = IconExtractor.ExtractIconLarge(txtPath.Text);

                if (smallIcon != null)
                    pSmall.BackgroundImage = smallIcon.ToBitmap();

                if (largeIcon != null)
                    pLarge.BackgroundImage = largeIcon.ToBitmap();
            }
        }

        //Textbox Drag-and-Drop events-------------------------------------
        private void txtPath_DragEnter(object sender, DragEventArgs e)
        {
            if (e.Data.GetDataPresent(DataFormats.FileDrop))
                e.Effect = DragDropEffects.Copy;
        }

        private void txtPath_DragDrop(object sender, DragEventArgs e)
        {
            string[] fileNames = (string[])e.Data.GetData(DataFormats.FileDrop);
            if (fileNames[0].EndsWith(".exe")) //proper extension
                txtPath.Text = fileNames[0]; //Get first element
        }

        private void btnSaveLarge_Click(object sender, EventArgs e)
        {
            if (saveFileDialog1.ShowDialog() == DialogResult.OK)
            {
                if (saveFileDialog1.FileName.EndsWith(".bmp"))
                    pLarge.BackgroundImage.Save(saveFileDialog1.FileName, System.Drawing.Imaging.ImageFormat.Bmp);
                else if (saveFileDialog1.FileName.EndsWith(".png"))
                    pLarge.BackgroundImage.Save(saveFileDialog1.FileName, System.Drawing.Imaging.ImageFormat.Png);

                MessageBox.Show("Image Saved");
            }
        }

        private void btnSaveSmall_Click(object sender, EventArgs e)
        {
            if (saveFileDialog1.ShowDialog() == DialogResult.OK)
            {
                if (saveFileDialog1.FileName.EndsWith(".bmp"))
                    pSmall.BackgroundImage.Save(saveFileDialog1.FileName, System.Drawing.Imaging.ImageFormat.Bmp);
                else if (saveFileDialog1.FileName.EndsWith(".png"))
                    pSmall.BackgroundImage.Save(saveFileDialog1.FileName, System.Drawing.Imaging.ImageFormat.Png);

                MessageBox.Show("Image Saved");
            }            
        }

        private void pLarge_BackgroundImageChanged(object sender, EventArgs e)
        {
            btnSaveLarge.Enabled = pLarge.BackgroundImage != null;
        }

        private void pSmall_BackgroundImageChanged(object sender, EventArgs e)
        {
            btnSaveSmall.Enabled = pSmall.BackgroundImage != null;
        }
        //-----------------------------------------------------------------
    }

    public class IconExtractor
    {
        [DllImport("shell32.dll", EntryPoint = "ExtractIconEx")]
        private static extern int ExtractIconExA(string lpszFile, int nIconIndex, ref IntPtr phiconLarge, ref IntPtr phiconSmall, int nIcons);

        [DllImport("user32")]
        private static extern int DestroyIcon(IntPtr hIcon);

        //Attempts to extract the small-version of the applicaiton's icon
        public static Icon ExtractIconSmall(string path)
        {
            IntPtr largeIcon = IntPtr.Zero;
            IntPtr smallIcon = IntPtr.Zero;
            ExtractIconExA(path, 0, ref largeIcon, ref smallIcon, 1);

            //Transform the bits into the icon image
            Icon returnIcon = null;
            if (smallIcon != IntPtr.Zero)
                returnIcon = Icon.FromHandle(smallIcon);

            //clean up
            DestroyIcon(largeIcon);

            return returnIcon;
        }

        //Attempts to extract the large-version of the application's icon
        public static Icon ExtractIconLarge(string path)
        {
            IntPtr largeIcon = IntPtr.Zero;
            IntPtr smallIcon = IntPtr.Zero;
            ExtractIconExA(path, 0, ref largeIcon, ref smallIcon, 1);

            //Transform the bits into the icon image
            Icon returnIcon = null;
            if (largeIcon != IntPtr.Zero)
                returnIcon = Icon.FromHandle(largeIcon);

            //clean up
            DestroyIcon(smallIcon);

            return returnIcon;
        }

        //Returns the large icon if found, if not the small icon
        public static Icon ExtractIcon(string path)
        {
            Icon largeIcon = ExtractIconLarge(path);

            if (largeIcon == null)
                return ExtractIconSmall(path);
            else
                return largeIcon;
        }
    }
}