//====================================================
//| Downloaded From                                  |
//| Visual C# Kicks - http://www.vcskicks.com/       |
//| License - http://www.vcskicks.com/license.html   |
//====================================================
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Drawing.Imaging;

namespace InvertImage
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }


        private void btnLoad_Click(object sender, EventArgs e)
        {
            if (openFileDialog1.ShowDialog() == DialogResult.OK)
            {
                try
                {
                    Image img = Image.FromFile(openFileDialog1.FileName);
                    picImg.Image = img;
                }
                catch (Exception)
                {
                    MessageBox.Show("Invalid image");
                }
            }
        }


        private void btnInvertGDI_Click(object sender, EventArgs e)
        {
            if (picImg.Image != null)
                picImg.Image = InvertImage(picImg.Image);
        }

        private void btnInvertMatrix_Click(object sender, EventArgs e)
        {
            if (picImg.Image != null)
                picImg.Image = InvertImageColorMatrix(picImg.Image);
        }

        private void btnInvertUnsafe_Click(object sender, EventArgs e)
        {
            if (picImg.Image != null)
                picImg.Image = InvertImageUnsafe(picImg.Image);
        }

        
        private static Image InvertImage(Image originalImg)
        {
            Bitmap invertedBmp = null;

            using (Bitmap originalBmp = new Bitmap(originalImg))
            {
                invertedBmp = new Bitmap(originalBmp.Width, originalBmp.Height);

                for (int x = 0; x < originalBmp.Width; x++)
                {
                    for (int y = 0; y < originalBmp.Height; y++)
                    {
                        //Get the color
                        Color clr = originalBmp.GetPixel(x, y);

                        //Invert the clr
                        clr = Color.FromArgb(255 - clr.R, 255 - clr.G, 255 - clr.B);

                        //Update the color
                        invertedBmp.SetPixel(x, y, clr);
                    }
                }
            }

            return (Image)invertedBmp;
        }

        private static Image InvertImageColorMatrix(Image originalImg)
        {
            Bitmap invertedBmp = new Bitmap(originalImg.Width, originalImg.Height);

            //Setup color matrix
            ColorMatrix clrMatrix = new ColorMatrix(new float[][]
                                                    {
                                                    new float[] {-1, 0, 0, 0, 0},
                                                    new float[] {0, -1, 0, 0, 0},
                                                    new float[] {0, 0, -1, 0, 0},
                                                    new float[] {0, 0, 0, 1, 0},
                                                    new float[] {1, 1, 1, 0, 1}
                                                    });

            using (ImageAttributes attr = new ImageAttributes())
            {
                //Attach matrix to image attributes
                attr.SetColorMatrix(clrMatrix);

                using (Graphics g = Graphics.FromImage(invertedBmp))
                {
                    g.DrawImage(originalImg, new Rectangle(0, 0, originalImg.Width, originalImg.Height),
                                0, 0, originalImg.Width, originalImg.Height, GraphicsUnit.Pixel, attr);
                }
            }

            return invertedBmp;
        }

        private static Image InvertImageUnsafe(Image originalImg)
        {
            Bitmap bmp = new Bitmap(originalImg);

            //Format is BGRA, NOT ARGB.
            BitmapData bmData = bmp.LockBits(new Rectangle(0, 0, bmp.Width, bmp.Height),
                                           ImageLockMode.ReadWrite,
                                           PixelFormat.Format32bppArgb);

            int stride = bmData.Stride;
            IntPtr Scan0 = bmData.Scan0;

            unsafe
            {
                byte* p = (byte*)(void*)Scan0;

                int nOffset = stride - bmp.Width * 4;
                int nWidth = bmp.Width;

                for (int y = 0; y < bmp.Height; y++)
                {
                    for (int x = 0; x < nWidth; x++)
                    {
                        p[0] = (byte)(255 - p[0]); //red
                        p[1] = (byte)(255 - p[1]); //green
                        p[2] = (byte)(255 - p[2]); //blue
                        //p[3] is alpha, don't want to invert alpha

                        p += 4;
                    }
                    p += nOffset;
                }
            }

            bmp.UnlockBits(bmData);

            return (Image)bmp;
        }


        private void linkLabel1_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            System.Diagnostics.Process.Start("http://www.vcskicks.com/");
        }
    }
}