﻿//====================================================
//| Downloaded From                                  |
//| Visual C# Kicks - http://www.vcskicks.com/       |
//| License - http://www.vcskicks.com/license.php    |
//====================================================
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;

namespace JavascriptStringUtility
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private string Unindent(string str, bool ignoreFirstLineIdent)
        {
            //Find the amount of whitespace to remove
            //from the beginning of each line
            bool isFirstLine = true;
            int amount = int.MaxValue;
            using (StringReader reader = new StringReader(str))
            {
                while (reader.Peek() != -1)
                {
                    string line = reader.ReadLine();
                    if (line.Trim() == string.Empty) continue; //skip empty lines
                    
                    //Count how many whitespaces there are
                    //at the beginning of the string
                    int whitespaceCount = 0;
                    for (int i = 0; i < line.Length; i++)
                    {
                        if (!char.IsWhiteSpace(line[i]))
                        {
                            whitespaceCount = i;
                            break;
                        }
                    }

                    //Update overall whitespace amount
                    if (whitespaceCount < amount &&
                        !(isFirstLine && ignoreFirstLineIdent))
                        amount = whitespaceCount;

                    if (isFirstLine)
                        isFirstLine = false;
                }
            }

            //Remove the amount of whitespaces from each line
            if (amount == 0)
                return str; //nothing changed
            else
            {
                isFirstLine = true;
                StringBuilder writer = new StringBuilder();
                using (StringReader reader = new StringReader(str))
                {
                    while (reader.Peek() != -1)
                    {
                        string line = reader.ReadLine();

                        //Remove whitespace at the beginning
                        if (line.Length > amount &&
                           !(isFirstLine && ignoreFirstLineIdent)) //skip first line if we are ignoring it
                            line = line.Substring(amount);

                        writer.AppendLine(line);

                        if (isFirstLine)
                            isFirstLine = false;
                    }
                }

                return writer.ToString();
            }
            
        }

        private string Escape(string str)
        {
            //Replace single-quotes (') with backslash-single-quote (\')
            int i = str.IndexOf("'");
            while (i > -1)
            {
                if (i == 0)
                {
                    str = @"\'" + str.Substring(1);
                }
                else if (str[i - 1] != '\\') //don't escape single quotes that have already been escaped
                {
                    str = str.Substring(0, i) + @"\'" + str.Substring(i + 1);
                }

                i = str.IndexOf("'", i + 1);
            }

            return str;
        }

        private string UnEscape(string str)
        {
            return str.Replace(@"\'", "'"); //remove backslashes next to single-quotes
        }

        public string ToJavascript(string str)
        {
            str = Unindent(str, true); //remove indenting

            StringBuilder writer = new StringBuilder();
            using (StringReader reader = new StringReader(str))
            {
                while (reader.Peek() != -1)
                {
                    string line = reader.ReadLine();

                    if (line != string.Empty)
                    {
                        line = "'" + Escape(line) + "'"; //quote escaped text

                        if (reader.Peek() != -1)
                            line += " +"; //add plus sign if there are more lines left
                    }

                    writer.AppendLine(line);
                }
            }

            return writer.ToString();
        }

        public string FromJavascript(string str)
        {
            StringBuilder writer = new StringBuilder();
            using (StringReader reader = new StringReader(str))
            {
                while (reader.Peek() != -1)
                {
                    string line = reader.ReadLine();

                    if (line != string.Empty)
                    {
                        if (line.StartsWith("'"))
                            line = line.Substring(1); //remove opening quote

                        if (line.EndsWith(" +"))
                            line = line.Substring(0, line.Length - 2); //remove plus sign

                        if (line.EndsWith("'"))
                            line = line.Substring(0, line.Length - 1); //remove closing quote

                        line = UnEscape(line); //unescape quotes
                    }

                    writer.AppendLine(line);
                }
            }

            return writer.ToString();
        }
        
        private void btnTo_Click(object sender, EventArgs e)
        {
            if (txtString.Text != string.Empty)
                txtString.Text = ToJavascript(txtString.Text);
        }

        private void btnFrom_Click(object sender, EventArgs e)
        {
            if (txtString.Text != string.Empty)
                txtString.Text = FromJavascript(txtString.Text);
        }

        private void txtString_KeyDown(object sender, KeyEventArgs e)
        {
            if (e.Control && e.KeyCode == Keys.A)
                txtString.SelectAll();
        }

        private void btnClear_Click(object sender, EventArgs e)
        {
            txtString.Clear();
        }

        private void linkLabel1_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            System.Diagnostics.Process.Start("http://www.vcskicks.com/");
        }
        
    }
}
