//====================================================
//| Downloaded From                                  |
//| Visual C# Kicks - http://www.vcskicks.com/       |
//| License - http://www.vcskicks.com/license.html   |
//====================================================
using System;
using System.Collections.Generic;
using System.Windows.Forms;
//Needed
using System.Reflection;
using System.IO;

namespace MemoryLauncher
{
    static class Program
    {
        /// <summary>
        /// The main entry point for the application.
        /// </summary>
        [STAThread]
        static void Main()
        {
            RunInternalExe("TestApp.exe");
        }

        private static void RunInternalExe(string exeName)
        {
            //Get the current assembly
            Assembly assembly = Assembly.GetExecutingAssembly();

            //Get the assembly's root name
            string rootName = assembly.GetName().Name;

            //Get the resource stream
            Stream resourceStream = assembly.GetManifestResourceStream(rootName + "." + exeName);

            //Verify the internal exe exists
            if (resourceStream == null)
                return;

            //Read the raw bytes of the resource
            byte[] resourcesBuffer = new byte[resourceStream.Length];

            resourceStream.Read(resourcesBuffer, 0, resourcesBuffer.Length);
            resourceStream.Close();

            //Load the bytes as an assembly
            Assembly exeAssembly = Assembly.Load(resourcesBuffer);

            //Execute the assembly
            exeAssembly.EntryPoint.Invoke(null, null); //no parameters
        }
    }
}