//Download from
//Visual C# Kicks - http://www.vcskicks.com/
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics; //Needed

namespace PerformanceTest
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void btnRunTest_Click(object sender, EventArgs e)
        {
            int trials = 100000000;
            Stopwatch timer = new Stopwatch();

            timer.Start();
            for (int x = 0; x < trials; x++)
            {
                //Test code here
            }
            timer.Stop();

            TimeSpan difference = new TimeSpan(timer.ElapsedTicks);

            lData.Items.Add(difference.ToString());

            updateAverage();
        }

        private void updateAverage()
        {
            TimeSpan total = new TimeSpan(0);

            for (int i = 0; i < lData.Items.Count; i++)
            {
                TimeSpan span;
                TimeSpan.TryParse(lData.Items[i].ToString(), out span);

                if (span != null)
                    total = total.Add(span);
            }

            if (lData.Items.Count != 0)
            {
                total = new TimeSpan((long)((double)total.Ticks / (double)lData.Items.Count));
                lAverage.Text = "Average: " + total.ToString();
            }
        }

        private void btnClear_Click(object sender, EventArgs e)
        {
            lData.Items.Clear();
        }

        private void linkLabel1_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            System.Diagnostics.Process.Start("http://www.vcskicks.com/");
        }
    }
}