//====================================================
//| Downloaded From                                  |
//| Visual C# Kicks - http://www.vcskicks.com/       |
//| License - http://www.vcskicks.com/license.php    |
//====================================================
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace QuadraticEquationSolver
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
            txtA.KeyPress += new KeyPressEventHandler(txt_KeyPress);
            txtB.KeyPress += new KeyPressEventHandler(txt_KeyPress);
            txtC.KeyPress += new KeyPressEventHandler(txt_KeyPress);
        }

        public static void SolveQuadratic(double a, double b, double c, out double x1, out double x2)
        {
            //Quadratic Formula: x = (-b +- sqrt(b^2 - 4ac)) / 2a

            //Calculate the inside of the square root
            double insideSquareRoot = (b * b) - 4 * a * c;

            if (insideSquareRoot < 0)
            {
                //There is no solution
                x1 = double.NaN;
                x2 = double.NaN;
            }
            else
            {
                //Compute the value of each x
                //if there is only one solution, both x's will be the same
                double sqrt = Math.Sqrt(insideSquareRoot);
                x1 = (-b + sqrt) / (2 * a);
                x2 = (-b - sqrt) / (2 * a);
            }
        }

        public static void SolveQuadratic(float a, float b, float c, out float x1, out float x2)
        {
            //Calculate the inside of the square root
            float insideSquareRoot = (b * b) - 4 * a * c;

            if (insideSquareRoot < 0)
            {
                //There is no solution
                x1 = float.NaN;
                x2 = float.NaN;
            }
            else
            {
                //Compute the value of each x
                //if there is only one solution, both x's will be the same
                float t = (float)(-0.5f * (b + Math.Sign(b) * Math.Sqrt(insideSquareRoot)));
                x1 = c / t;
                x2 = t / a;
            }
        }

        private void btnSolve_Click(object sender, EventArgs e)
        {
            double a = 0;
            double b = 0;
            double c = 0;
            double x1 = 0;
            double x2 = 0;

            //Get user input
            double.TryParse(txtA.Text, out a);
            double.TryParse(txtB.Text, out b);
            double.TryParse(txtC.Text, out c);

            //Solve the formula
            SolveQuadratic(a, b, c, out x1, out x2);

            //Display results
            txtSolution.Text = a + "x + " + b + "x + " + c + " = 0" + Environment.NewLine +
                               Environment.NewLine +
                               "x1 = " + x1 + Environment.NewLine +
                               "x2 = " + x2;
        }


        private void btnSolveFloat_Click(object sender, EventArgs e)
        {
            float a = 0;
            float b = 0;
            float c = 0;
            float x1 = 0;
            float x2 = 0;

            //Get user input
            float.TryParse(txtA.Text, out a);
            float.TryParse(txtB.Text, out b);
            float.TryParse(txtC.Text, out c);

            //Solve the formula
            SolveQuadratic(a, b, c, out x1, out x2);

            //Display results
            txtSolution.Text = a + "x + " + b + "x + " + c + " = 0" + Environment.NewLine +
                               Environment.NewLine +
                               "x1 = " + x1 + Environment.NewLine +
                               "x2 = " + x2;
        }

        private void txt_KeyPress(object sender, KeyPressEventArgs e)
        {
            //Allow backspace
            if (e.KeyChar == (char)Keys.Back)
                return;

            //Allow only one negative sign
            if (e.KeyChar == '-' && ((TextBox)sender).Text.IndexOf('-') == -1)
                return;

            //Allow only one period
            if (e.KeyChar == '.' && ((TextBox)sender).Text.IndexOf('.') == -1)
                return;

            //Don't allow anything else except numbers
            e.Handled = !System.Text.RegularExpressions.Regex.IsMatch(e.KeyChar.ToString(), "\\d+");
        }

        private void linkLabel1_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            System.Diagnostics.Process.Start("http://www.vcskicks.com/");
        }
    }
}