//http://www.vcskicks.com/
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO; //Needed

namespace ReadLines
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private string readTextFile1(string path)
        {
            //Method 1       
     
            //Load the file contents
            StreamReader textFile = new StreamReader(path);
            string fileContents = textFile.ReadToEnd();
            textFile.Close();

            //Find the number of lines
            StringReader reader = new StringReader(fileContents);
            int lineCount = 0;
            while (reader.ReadLine() != null)
            {
                lineCount++;
            }
            lineCount--;

            //Now read the file line by line
            reader = new StringReader(fileContents);
            string outputText = "";
            for (int i = 0; i <= lineCount; i++)
            {
                outputText += reader.ReadLine() + Environment.NewLine;
            }
            //This may seem redudant, but here is where you would do any line-by-line processing
            //In this case we do nothing so it seems uneccessary.

            return outputText;
        }

        private string readTextFile2(string path)
        {
            //Method 2       

            //Load the file contents
            FileStream textFile = new FileStream(path, FileMode.Open);
            byte[] buffer = new byte[textFile.Length];
            textFile.Read(buffer, 0, buffer.Length);

            //Find the number of lines
            //Remember the char value for the end of a line is 13 + 10
            int lineCount = 0;
            for (int i = 0; i < buffer.Length; i++)
            {
                if (buffer[i] == 13)
                    if (i + 1 < buffer.Length && buffer[i + 1] == 10)
                        lineCount++;
            }

            //Now read the file line by line
            StringReader reader = new StringReader(Encoding.ASCII.GetString(buffer));
            string outputText = "";
            for (int i = 0; i <= lineCount; i++)
            {
                outputText += reader.ReadLine() + Environment.NewLine;
            }
            //This may seem redudant, but here is where you would do any line-by-line processing
            //In this case we do nothing so it seems uneccessary.

            return outputText;
            //If you rather just return the string straight away, use
            //return Encoding.ASCII.GetString(buffer);
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            txtPath.Text = Application.StartupPath + "//TestFile.txt";
        }

        private void btnRead_Click(object sender, EventArgs e)
        {
            //txtData.Text = readTextFile1(txtPath.Text);
            txtData.Text = readTextFile2(txtPath.Text);
        }

        private void lbVCKicks_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            System.Diagnostics.Process.Start("http://www.vcskicks.com/");
        }
    }
}