//====================================================
//| Downloaded From                                  |
//| Visual C# Kicks - http://www.vcskicks.com/       |
//| License - http://www.vcskicks.com/license.html   |
//====================================================
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Reflection; //Required

namespace ReflectionProperties
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();

            //Fill the combo box with all public properties of the sample button
            PopulatePropertyList(btnSample, cProperties);
        }

        private void btnValue_Click(object sender, EventArgs e)
        {
            if (cProperties.Text != string.Empty)
                MessageBox.Show(cProperties.Text + ": " + GetControlProperty(btnSample, cProperties.Text));
        }

        /// <summary>
        /// Returns the value of the specified property of a control in string format
        /// </summary>
        private string GetControlProperty(Control control, string property)
        {
            Type controlType = control.GetType();
            PropertyInfo propInfo = controlType.GetProperty(property);
            string value = string.Empty;
            try
            {
                value = propInfo.GetValue(control, null).ToString();
            }
            catch (Exception)
            {
                MessageBox.Show("Property does not exist for the control or\n" +
                                "the property is not assigned or\n" + 
                                "the property cannot be displayed as a string.");
            }

            return value;
        }

        /// <summary>
        /// Gets all the properties of a control and populates a combobox with them
        /// </summary>
        private void PopulatePropertyList(Control control, ComboBox list)
        {
            Type controlType = control.GetType();

            list.Items.Clear();
            foreach (PropertyInfo propInfo in controlType.GetProperties())
            {
                list.Items.Add(propInfo.Name);
            }

            list.Text = list.Items[0].ToString();
        }

        private void linkLabel1_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            System.Diagnostics.Process.Start("http://www.vcskicks.com/");
        }
    }
}