// ================================================
// | Downloaded From                              |
// | Visual C# Kicks - http://www.vcskicks.com/   |
// ================================================

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Text.RegularExpressions;

namespace SimplifyRoots
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private Boolean IsDecimal(double inputNum)
        {
            return (int)inputNum != inputNum;
        }

        private void Button1_Click(object sender, EventArgs e)
        {
            //Get the input
            double inputNum = double.Parse(txtnum.Text);

            //Check if it is a perfect square number
            if (!IsDecimal(Math.Sqrt(inputNum)))
            {
                txtout1.Text = Math.Sqrt(inputNum).ToString();
                txtout2.Text = "-";
                return;
            }

            //Main algorithm
            //Checks for integers whose squared value is a multiple of the input value
            double testSquare = 0;
            for (int i = (int)Math.Floor(Math.Sqrt(inputNum)); i >= 2; i--)
            {
                testSquare = inputNum / (double)(i * i);

                if (!IsDecimal(testSquare))
                {
                    txtout1.Text = i.ToString();
                    txtout2.Text = (inputNum / (i * i)).ToString();
                    return;
                }
            }

            txtout1.Text = "-";
            txtout2.Text = "-";
        }

        private void linkLabel1_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            System.Diagnostics.Process.Start("http://www.vcskicks.com/");
        }

        private void txtnum_KeyPress(object sender, KeyPressEventArgs e)
        {
            //Allow only numbers as input (http://www.vcskicks.com/numbers_only_textbox.html);
            e.Handled = !System.Text.RegularExpressions.Regex.IsMatch(e.KeyChar.ToString(), "\\d+");
        }
    }
}