
using System;
//====================================================
//| Downloaded From                                  |
//| Visual C# Kicks - http://www.vcskicks.com/       |
//| License - http://www.vcskicks.com/license.html   |
//====================================================
using System.Collections.Generic;
using System.Text;
using System.Drawing;
using System.ComponentModel;
using System.ComponentModel.Design;
using System.Windows.Forms.Design;

namespace SmartTags
{
    class TaskButtonDesigner : ControlDesigner
    {
        private DesignerActionListCollection actionListCollection;

        public override DesignerActionListCollection ActionLists
        {
            get
            {
                if (actionListCollection == null)
                {
                    actionListCollection = new DesignerActionListCollection();
                    actionListCollection.Add(new TaskButtonActionList(this.Component));
                }

                return actionListCollection;
            }
        }

    }

    internal class TaskButtonActionList : DesignerActionList
    {
        private TaskButton buttonControl;
        private DesignerActionUIService designerService;

        public TaskButtonActionList(IComponent component) : base(component)
        {
            buttonControl = (TaskButton)component;
            designerService = (DesignerActionUIService)this.GetService(typeof(DesignerActionUIService));
        }

        //---Properties
        public Color ForeColor
        {
            get { return buttonControl.ForeColor; }
            set { buttonControl.ForeColor = value; }
        }

        //---Methods
        public void MakeSquare()
        {
            //Resize Button
            if (buttonControl.Width > buttonControl.Height)
                buttonControl.Width = buttonControl.Height;
            else
                buttonControl.Height = buttonControl.Width;

            //Refresh
            designerService.Refresh(buttonControl);
        }

        public override DesignerActionItemCollection GetSortedActionItems()
        {
            DesignerActionItemCollection items = new DesignerActionItemCollection();

            //Headers
            items.Add(new DesignerActionHeaderItem("Category 1"));

            //Properties
            items.Add(new DesignerActionPropertyItem("ForeColor", "Foreground Color", "Category 1"));

            //Methods
            items.Add(new DesignerActionMethodItem(this, "MakeSquare", "Make Button Square"));

            return items;
        }
    }
}
