//====================================================
//| Downloaded From                                  |
//| Visual C# Kicks - http://www.vcskicks.com/       |
//| License - http://www.vcskicks.com/license.html   |
//====================================================
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Runtime.InteropServices;

namespace SnapForm
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();

            this.SetStyle(ControlStyles.AllPaintingInWmPaint, true);
            this.SetStyle(ControlStyles.ResizeRedraw, true);

        }

        const int WM_NCMOUSEMOVE = 0xA0;
        const int WM_NCLBUTTONDOWN = 0xA1;
        const int WM_WINDOWPOSCHANGING = 0x0046;
        const int WM_WINDOWPOSCHANGED = 0x0047;

        const int PADDING = 40;

        Size lastSize = Size.Empty;
        Point lastPoint = Point.Empty;

        bool isDocking = false;
        bool mouseDown = false;

        private struct WindowPos
        {
            public int hwnd;
            public int hWndInsertAfter;
            public int x;
            public int y;
            public int cx;
            public int cy;
            public int flags;
        }

        protected override void WndProc(ref Message m)
        {
            if (m.Msg == WM_NCLBUTTONDOWN) //Left Mouse Down
            {
                //Flag that the mouse has clicked on the titlebar
                if (!mouseDown)
                {
                    mouseDown = true;
                    lastPoint = Cursor.Position;
                }
            }
            else if (m.Msg == WM_NCMOUSEMOVE) //Left Mouse Up
            {
                if (mouseDown)
                {                    
                    //MOUSE UP

                    //Flag that the mouse click has been released
                    mouseDown = false;

                    if (Cursor.Position.X == 0) //Left Docking
                    {
                        if (!isDocking)
                        {
                            isDocking = true;
                            lastSize = this.Size;                           

                            DockToLeft();                            
                        }
                    }
                    else if (Cursor.Position.X == Screen.FromControl(this).WorkingArea.Width - 1) //Right Docking
                    {
                        if (!isDocking)
                        {
                            lastSize = this.Size;
                            isDocking = true;

                            DockToRight();                            
                        }
                    }
                    else if (Cursor.Position.Y == 0) //Top Docking
                    {
                        if (!isDocking)
                        {
                            lastSize = this.Size;
                            isDocking = true;

                            DockToTop();                            
                        }
                    }
                    else
                        if (!isDocking && lastSize != Size.Empty)
                            RestoreSize();
                }
            }
            else if (m.Msg == WM_WINDOWPOSCHANGING)
            {
                if (isDocking)
                {
                    if (Math.Abs(Cursor.Position.Y - lastPoint.Y) <= 80)
                    {
                        //Keep window snapped to the top of the screen

                        //get the window's position
                        WindowPos pos = (WindowPos)Marshal.PtrToStructure(m.LParam, typeof(WindowPos));

                        pos.y = 0; //reset the top to 0

                        //set the window's position
                        Marshal.StructureToPtr(pos, m.LParam, true);
                    }
                    else
                    {
                        //Stop docking
                        isDocking = false;
                    }
                }
            }

            base.WndProc(ref m);
        }

        private void DockToLeft()
        {
            this.Top = 0;
            this.Left = 0;
            this.Height = Screen.FromControl(this).WorkingArea.Height;
            this.Width = Screen.FromControl(this).WorkingArea.Width / 3;            
        }

        private void DockToRight()
        {
            this.Height = Screen.FromControl(this).WorkingArea.Height;
            this.Width = Screen.FromControl(this).WorkingArea.Width / 3;
            this.Left = Screen.FromControl(this).WorkingArea.Width - this.Width;
            this.Top = 0;
        }

        private void DockToTop()
        {
            this.Height = Screen.FromControl(this).WorkingArea.Height;
            this.Width = Screen.FromControl(this).WorkingArea.Width;
            this.Left = 0;
            this.Top = 0;
        }

        private void RestoreSize()
        {
            this.Size = lastSize;

            lastSize = Size.Empty;
        }

        private void linkLabel1_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            System.Diagnostics.Process.Start("http://www.vcskicks.com/");
        }
    }
}