//Downloaded from
//Visual C# Kicks - http://www.vcskicks.com/
using System;
using System.Collections; //Required
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace Sorting2DPoints
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private Point[] samplePoints = { new Point(1, 2), new Point(3, 3), new Point(4, 3),
                                         new Point(5, 5), new Point(6, 1), new Point(13, 2),
                                         new Point(0, 4), new Point(2, 23), new Point(32, 3) };

        //Converts an array of Points into a single string
        private string pointsToString(Point[] pointArray)
        {
            string output = "";

            foreach (Point point in pointArray)
            {
                output += "(" + point.X.ToString() + ", " + point.Y.ToString() + ")" + Environment.NewLine;
            }

            return output;
        }

        public void sortPoints(bool x)
        {
            //Create another array so we can keep the original array out of order
            Point[] copySamplePoints = new Point[samplePoints.Length];
            samplePoints.CopyTo(copySamplePoints, 0);

            if (x)
                Array.Sort(copySamplePoints, new PointSort(PointSort.Mode.X));
            else
                Array.Sort(copySamplePoints, new PointSort(PointSort.Mode.Y));

            txtAfter.Text = pointsToString(copySamplePoints);
            txtBefore.Text = pointsToString(samplePoints);

            //Clean up
            copySamplePoints = null;

        }

        private void Form1_Load(object sender, EventArgs e)
        {
            txtBefore.Text = pointsToString(samplePoints);
        }

        private void btnSortX_Click(object sender, EventArgs e)
        {
            sortPoints(true);
        }

        private void btnSortY_Click(object sender, EventArgs e)
        {
            sortPoints(false);
        }
    }

    public class PointSort : IComparer
    {
        public enum Mode
        {
            X,
            Y
        }

        Mode currentMode = Mode.X;

        public PointSort(Mode mode)
        {
            currentMode = mode;
        }

        //Comparing function
        //Returns one of three values - 0 (equal), 1 (greater than), 2 (less than)
        int IComparer.Compare(object a, object b)
        {
            Point point1 = (Point)a;
            Point point2 = (Point)b;

            if (currentMode == Mode.X) //Compare X values
            {
                if (point1.X > point2.X)
                    return 1;
                else if (point1.X < point2.X)
                    return -1;
                else
                    return 0;
            }
            else
            {
                if (point1.Y > point2.Y) //Compare Y Values
                    return 1;
                else if (point1.Y < point2.Y)
                    return -1;
                else
                    return 0;
            }
        }
    }
}